version 10
clear
set more off
cd "C:\Users\Andrew\My publications\Aust - elections & local unemp\Fundamental Attribution Error & State Elections\"

* This dofile is written to accompany this paper:
* Andrew Leigh & Mark McLeish, 2009, "Are State Elections Affected by the National Economy? Evidence from Australia", Economic Record
* Any use of the data or dofile should cite that paper. 
* Questions should be directed to andrew_leigh@ksg02.harvard.edu.

* There are two dofiles - one to set up the data, and one to run the regressions. The regressions dofile will run independently, as the
* files provided in the zipfile include temp_elections.dta.

****************************
* Setting up labour force data 
* (for calculating rest of Aust numbers)
****************************
use census_labour_force_1933_1976, clear
tsset year
tsfill
replace nsw=nsw+act
replace sa=sa+nt
drop australia act nt
for any nsw vic qld sa wa tas : ipolate X year, gen(temp) \ replace X=temp \ drop temp
gen australia=nsw+vic+qld+sa+wa+tas
save temp_labour_force_wide_1933_1976, replace
for any nsw vic qld sa wa tas: gen lfshareX=X/australia \ drop X
drop australia
reshape long lfshare, i(year) j(state) str
expand 22 if year==1933
bysort state: egen seq=seq() if year==1933
replace year=year-seq+1 if year==1933
drop seq 
bysort year: egen australia=sum(lfshare)
sum australia
drop australia
drop if year>1971
sort state year
save temp_labour_force, replace
use lfs_labour_force_1971_2006, clear
drop australia
gen australia=nsw+vic+qld+sa+wa+tas+act+nt if year>=1978
replace australia=nsw+vic+qld+sa+wa+tas+nt if year==1977
replace australia=nsw+vic+qld+sa+wa+tas if year<=1976
save temp_labour_force_wide_1971_2006, replace
for any nsw vic qld sa wa tas act nt: gen lfshareX=X/australia \ drop X
drop australia
reshape long lfshare, i(year) j(state) str
bysort year: egen australia=sum(lfshare)
sum australia
drop australia
sort state year 
merge state year using temp_labour_force, 
drop _merge
sort state year
sort state year
save temp_labour_force, replace

****************************
* Setting up biz cycle
****************************
use harding_business_cycle, clear
ren date year
tsset year
gen cycle=_n if st~=l.st
replace cycle=l.cycle if cycle==.
expand 6 if year==2001
bysort year: egen seq=seq()
replace year=year+seq-1 if year==2001
egen bizcycle=group(cycle)
drop lngdp st seq cycle
sort year
save temp_bizcycle, replace

*****************************
* Setting up state inflation.
* As with unemp, we use Sept quarter CPI
* inflation is year on year change.
*****************************
use state_inflation, clear
keep if substr(date,1,1)=="9"
gen year=real(substr(date,-4,4))
drop date
reshape long cpi_,i(year) j(state) str
ren cpi_ cpi
replace state="qld" if state=="q"
drop if state=="aust"
egen stateno=group(state)
tsset stateno year
gen i=(cpi-l.cpi)/l.cpi
sort state year
merge state year using temp_labour_force, nokeep
drop _merge
for any nsw vic qld sa wa tas act nt: gen temp1=i if state=="X" \ bysort year: egen i_X=max(temp1) \ gen temp2=lfshare if state=="X" \ bysort year: egen lfshare_X=max(temp2) \ drop temp*
gen i_rest=.
for any nsw vic qld sa wa tas: replace i_rest=(i_nsw*lfshare_nsw)+(i_vic*lfshare_vic)+(i_sa*lfshare_sa)+(i_wa*lfshare_wa)+(i_tas*lfshare_tas)+(i_qld*lfshare_qld)-(i_X*lfshare_X) if year<=1976 & state=="X"
for any nsw vic qld sa wa tas nt: replace i_rest=(i_nsw*lfshare_nsw)+(i_vic*lfshare_vic)+(i_sa*lfshare_sa)+(i_wa*lfshare_wa)+(i_tas*lfshare_tas)+(i_qld*lfshare_qld)+(i_nt*lfshare_nt)-(i_X*lfshare_X) if year==1977 & state=="X"
for any nsw vic qld sa wa tas nt act: replace i_rest=(i_nsw*lfshare_nsw)+(i_vic*lfshare_vic)+(i_sa*lfshare_sa)+(i_wa*lfshare_wa)+(i_tas*lfshare_tas)+(i_qld*lfshare_qld)+(i_nt*lfshare_nt)+(i_act*lfshare_act)-(i_X*lfshare_X) if year>=1978 & state=="X"
drop i_nsw i_vic i_qld i_sa i_wa i_tas i_act i_nt lfshare* stateno
la var i "State inflation rate"
la var i_rest "Rest of Australia inflation rate"
sort state year
save temp_i, replace

****************************
* Setting up unemployment data
****************************
use dx_unemployment_1971-77,clear
replace nt=nt[_n+1] if quarter=="Sep-77"
keep if substr(quarter,1,3)=="Sep"
gen year=1900+real(substr(quarter,5,2))
drop quarter
order year
sort year
save temp_u_1971-77,replace
use lfs_unemp_1978-2006,clear
for any australia nsw vic qld sa wa tas act nt: replace X=X/100
keep if substr(monthyear,1,3)=="Aug"
gen year=real(substr(monthyear,5,4))
drop monthyear
order year
sort year
append using temp_u_1971-77
sort year
save unemployment_raw_1971_2006,replace

use temp_labour_force_wide_1933_1976, clear
*append using lfs_labour_force_1971_2006
*drop nt act
for any australia nsw vic qld sa wa tas: ren X X_lf
sort year
merge year using unemployment_raw_1947_1970
drop _merge
for any australia nsw vic qld sa wa tas: replace X=X/X_lf \ drop X_lf
drop if year<1947 | year>1970
sort year
save temp_unemployment_rate_1947_1970,replace

use unemployment_raw_1913_1947, clear
sort year
merge year using temp_unemployment_rate_1947_1970
drop _merge
sort year
merge year using unemployment_raw_1971_2006 
drop _merge
sort year
merge year using aust_butlin_unemployment, nokeep 
ren aust_unemployment butlin_unemployment
replace butlin_unemployment=butlin_unemployment/100
gen ratio=australia/butlin_unemployment
for var nsw vic qld sa wa tas act nt australia: replace X=X/ratio if year<=1970
drop ratio butlin _merge
for any nsw vic qld sa wa tas act nt australia: ren X uX
save unemployment_by_state_wide, replace
reshape long u, i(year) j(state) str
save unemployment_by_state_long, replace
drop if state=="australia"
sort state year
merge state year using temp_labour_force
drop _merge
for any nsw vic qld sa wa tas act nt: gen temp1=u if state=="X" \ bysort year: egen u_X=max(temp1) \ gen temp2=lfshare if state=="X" \ bysort year: egen lfshare_X=max(temp2) \ drop temp*
gen u_rest=.
for any nsw vic qld sa wa tas: replace u_rest=((u_nsw*lfshare_nsw)+(u_vic*lfshare_vic)+(u_sa*lfshare_sa)+(u_wa*lfshare_wa)+(u_tas*lfshare_tas)+(u_qld*lfshare_qld)-(u_X*lfshare_X))/(1-lfshare_X) if year<=1976 & state=="X"
for any nsw vic qld sa wa tas nt: replace u_rest=((u_nsw*lfshare_nsw)+(u_vic*lfshare_vic)+(u_sa*lfshare_sa)+(u_wa*lfshare_wa)+(u_tas*lfshare_tas)+(u_qld*lfshare_qld)+(u_nt*lfshare_nt)-(u_X*lfshare_X))/(1-lfshare_X) if year==1977 & state=="X"
for any nsw vic qld sa wa tas nt act: replace u_rest=((u_nsw*lfshare_nsw)+(u_vic*lfshare_vic)+(u_sa*lfshare_sa)+(u_wa*lfshare_wa)+(u_tas*lfshare_tas)+(u_qld*lfshare_qld)+(u_nt*lfshare_nt)+(u_act*lfshare_act)-(u_X*lfshare_X))/(1-lfshare_X) if year>=1978 & state=="X"
drop u_nsw u_vic u_qld u_sa u_wa u_tas u_act u_nt lfshare_*
la var u "State unemployment rate"
la var u_rest "Rest of Australia unemployment rate"
* Testing for structural breaks
*egen stateno=group(state)
*tsset stateno year
*for any nsw vic qld sa wa tas act nt: zandrews u if state=="X" \ graph save X
*gr combine nsw.gph vic.gph qld.gph sa.gph wa.gph tas.gph act.gph nt.gph
*drop stateno

* Looking at U rate in all other states, interacted with partisanship
sort state year
merge state year using elections_for_merge, keep(alp) nokeep
drop _merge
egen stateno=group(state)
tsset stateno year
tsfill
replace alp=l.alp if alp==.
replace alp=l.alp if alp==.
replace alp=l.alp if alp==.
bysort year: egen temp1=sum(u) if alp==1
bysort year: egen temp2=count(u) if alp==1
bysort year: egen temp3=mode(temp1)
bysort year: egen temp4=mode(temp1)
gen u_rest_sameparty=(temp3-u)/(temp4-1) if alp==1
gen u_rest_diffparty=(temp3-u)/(temp4-1) if alp==0
drop temp*
bysort year: egen temp1=sum(u) if alp==0
bysort year: egen temp2=count(u) if alp==0
bysort year: egen temp3=mode(temp1)
bysort year: egen temp4=mode(temp1)
replace u_rest_sameparty=(temp3-u)/(temp4-1) if alp==0
replace u_rest_diffparty=(temp3-u)/(temp4-1) if alp==1
drop temp*
drop alp stateno

sort state year
save temp_u, replace

* Graph appendix figure 1
for any nsw vic qld sa wa tas nt act \ any "New South Wales" "Victoria" "Queensland" "South Australia" "Western Australia" "Tasmania" "Northern Territory" "Australian Capital Territory": replace state="Y" if state=="X"
*set scheme s1color
*tw line u u_rest year,legend(cols(1)) by(state,ti("Appendix Figure 1: Unemployment Rates by State") note("")) xti("") lcolor(red blue) lpattern(dash solid) lwidth(medthick medthick)
set scheme s1mono
tw line u u_rest year,legend(cols(1)) by(state,ti("Appendix Figure 1: Unemployment Rates by State") note("") ixaxes) xti("") lcolor(black gray) lpattern(solid dash) lwidth(medthick medthick)
graph export figa1.wmf,replace
graph export figa1.eps,replace
graph save figa1.gph,replace

* UK unemployment data
use uk_unemployment_1971-2008, clear
gen year=real(substr(month,-4,4))
collapse unemployment,by(year)
ren unemployment uk_unemp
sort year
save temp_uk_u, replace

use uk_unemployment_1870-1999, clear
gen ratio=u_hatton/u_feinstein
egen meanratio=mean(ratio)
gen unemployment_old=u_hatton
replace unemployment_old=u_feinstein*meanratio if unemployment==.
keep year unemployment_old
sort year
merge year using temp_uk_u
drop _merge
gen ratio=uk_unemp/unemployment_old
egen meanratio=mean(ratio)
list year ratio
replace uk_unemp=unemployment_old*meanratio if uk_unemp==.
keep uk_unemp year
sort year
save temp_uk_u, replace

********************************************
* Combining files
********************************************
use elections_for_merge, clear
sort state year
merge state year using temp_u, nokeep 
list if u==.
drop _merge

sort state year
merge state year using temp_i, nokeep
list if i==.
drop _merge

sort year
merge year using us_unemployment, nokeep
tab _merge
drop _merge
replace us_unemp=us_unemp/100

sort year
merge year using temp_uk_u, nokeep
tab _merge
drop _merge
replace uk_unemp=uk_unemp/100

sort state year
gen du=u-u[_n-1] if state==state[_n-1]
gen du_rest=u_rest-u_rest[_n-1] if state==state[_n-1]
gen di=i-i[_n-1] if state==state[_n-1]
gen di_rest=i_rest-i_rest[_n-1] if state==state[_n-1]
gen dus_unemp=us_unemp-us_unemp[_n-1] if state==state[_n-1]
gen duk_unemp=uk_unemp-uk_unemp[_n-1] if state==state[_n-1]
list state year if du==.
drop if du==.

tab alp
gen alp_federal=1 if (alp==1 & same_fed==1) | (alp==0 & same_fed==0)
recode alp_federal .=0
tab alp_federal
drop alp_federal

sort year
merge year using temp_bizcycle
drop _merge

save temp_elections, replace

